/*	Renegade Scripts.dll
	SSGM CTF scripts and functions
	Copyright 2007 Vloktboky, Whitedragon(MDB), Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

#ifndef CTF_H
#define CTF_H

#include "gmsettingsclass.h"

//CTF specific settings
struct CTFSettings : public virtual SettingsLoader {
	CTFSettings(const char *ININame) : SettingsLoader(ININame) {
		CTFCapLimit = 0;
		CTFRegenForHolder = false;
		CTFRegenAmount = 0;
		CTFCapPoints = 0;
		CTFCapPointsTeam = 0;
		CTFCapMoney = 0;
		CTFCapMoneyTeam = 0;
		CTFReturnTime = 0;
		CTFFriendlyFlagRadar = false;
		CTFEnemyFlagRadar = false;
		CTFEnableReverse = false;
	}

	virtual void Load();

	//CTF settings added in 1.6
	int CTFClass;
	std::string CTFClassName;
	bool CTFEnableReverse;
	bool CTFReverse;
	bool CTFRegenForHolder;
	float CTFRegenAmount;
	std::string CTFFlagPreset;
	std::string CTFFlagModel[2];
	std::string CTFFlagBackPreset;
	std::string CTFPedPreset[2];
	int CTFCapLimit;
	Vector3 CTFFlagOffset;
	Vector3 CTFPedPos[2];
	float CTFCapPoints;
	float CTFCapPointsTeam;
	float CTFCapMoney;
	float CTFCapMoneyTeam;
	float CTFReturnTime;
	bool CTFFriendlyFlagRadar;
	bool CTFEnemyFlagRadar;
};

//CTF specific data
struct CTFData {
	CTFData() {
		CTFFlagHolder[0] = 0;
		CTFFlagHolder[1] = 0;
		CTFFlagAttached[0][0] = 0;
		CTFFlagAttached[0][1] = 0;
		CTFFlagAttached[1][0] = 0;
		CTFFlagAttached[1][1] = 0;
		CTFCaps[0] = 0;
		CTFCaps[1] = 0;
	}
	int CTFFlagHolder[2];
	int CTFFlagAttached[2][2];
	int CTFCaps[2];
	int CTFFlagLoc[2];
	int CTFFlagIcon[2];
};

void CTF_Level_Loaded();
void CTF_GameOver();
void CTF_Player_Join(int ID);
void CTF_ObjectHook(GameObject *obj);


//******************************************************************************
//**************************** CTF RELATED SCRIPTS *****************************
//******************************************************************************

//Attached to the flag when it's on the pedestal.
class MDB_SSGM_CTF_Flag : public MDB_SSGM_Base {
	void NewCreated(GameObject *obj);
	void Custom(GameObject *obj, int message, int param, GameObject *sender);
	bool PickedUp;
};

//Attached to the flag when it's on the ground.
class MDB_SSGM_CTF_DropFlag : public ScriptImpClass {
	void Created(GameObject *obj);
	void Custom(GameObject *obj, int message, int param, GameObject *sender);
	void Timer_Expired(GameObject *obj, int number);
	void Destroyed(GameObject *obj);
	bool PickedUp;
};

//Attached to the player carrying the flag.
class MDB_SSGM_CTF_FlagHolder : public ScriptImpClass {
	void Created(GameObject *obj);
	void Killed(GameObject *obj, GameObject *shooter);
	void Destroyed(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
	void Custom(GameObject *obj, int message, int param, GameObject *sender);
	bool Dropped;
};

//Announces the capture limit and class.
class MDB_SSGM_CTF_Announcement : public MDB_SSGM_Base {
	void NewCreated(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
	void Custom(GameObject *obj, int message, int param, GameObject *sender);
};

#endif
